﻿
-- --------------------------------------------------
-- Entity Designer DDL Script for SQL Server 2005, 2008, 2012 and Azure
-- --------------------------------------------------
-- Date Created: 11/04/2019 13:19:40
-- Generated from EDMX file: C:\Workspaces\WizdomModern\wizdom-classic\GovernMetadata.Model\GovernMetadataModel.edmx
-- --------------------------------------------------

SET QUOTED_IDENTIFIER OFF;
GO
IF SCHEMA_ID(N'dbo') IS NULL EXECUTE(N'CREATE SCHEMA [dbo]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------

IF OBJECT_ID(N'[dbo].[FK_GM_ItemTypeGM_Item]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_Item] DROP CONSTRAINT [FK_GM_ItemTypeGM_Item];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_ItemGM_Metadata]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_Metadata] DROP CONSTRAINT [FK_GM_ItemGM_Metadata];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_MetadataGM_MetadataDefinition]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_Metadata] DROP CONSTRAINT [FK_GM_MetadataGM_MetadataDefinition];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_ItemTypeGM_Event]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_EventRegistration] DROP CONSTRAINT [FK_GM_ItemTypeGM_Event];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_ItemTypeGM_ItemTypeMetadataDefinitionBinding]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding] DROP CONSTRAINT [FK_GM_ItemTypeGM_ItemTypeMetadataDefinitionBinding];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_ItemTypeMetadataDefinitionBindingGM_MetadataDefinition]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding] DROP CONSTRAINT [FK_GM_ItemTypeMetadataDefinitionBindingGM_MetadataDefinition];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_ItemGM_ItemHistory]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_ItemHistory] DROP CONSTRAINT [FK_GM_ItemGM_ItemHistory];
GO
IF OBJECT_ID(N'[dbo].[FK_GM_ItemGM_Resource]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GM_Resource] DROP CONSTRAINT [FK_GM_ItemGM_Resource];
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------

IF OBJECT_ID(N'[dbo].[GM_Item]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_Item];
GO
IF OBJECT_ID(N'[dbo].[GM_ItemType]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_ItemType];
GO
IF OBJECT_ID(N'[dbo].[GM_EventRegistration]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_EventRegistration];
GO
IF OBJECT_ID(N'[dbo].[GM_Metadata]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_Metadata];
GO
IF OBJECT_ID(N'[dbo].[GM_MetadataDefinition]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_MetadataDefinition];
GO
IF OBJECT_ID(N'[dbo].[GM_EventHistory]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_EventHistory];
GO
IF OBJECT_ID(N'[dbo].[GM_AdminChangeLog]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_AdminChangeLog];
GO
IF OBJECT_ID(N'[dbo].[GM_ItemHistory]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_ItemHistory];
GO
IF OBJECT_ID(N'[dbo].[GM_ItemTypeMetadataDefinitionBinding]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding];
GO
IF OBJECT_ID(N'[dbo].[GM_Resource]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_Resource];
GO
IF OBJECT_ID(N'[dbo].[GM_WhitelistedRequest]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GM_WhitelistedRequest];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'GM_Item'
CREATE TABLE [dbo].[GM_Item] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ItemTypeId] int  NOT NULL,
    [Deleted] bit  NOT NULL,
    [Created] datetimeoffset  NOT NULL,
    [CreatedBy] int  NOT NULL,
    [Modified] datetimeoffset  NULL,
    [ModifiedBy] int  NULL
);
GO

-- Creating table 'GM_ItemType'
CREATE TABLE [dbo].[GM_ItemType] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'GM_EventRegistration'
CREATE TABLE [dbo].[GM_EventRegistration] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ItemTypeId] int  NOT NULL,
    [EventName] nvarchar(max)  NOT NULL,
    [Configuration] nvarchar(max)  NULL,
    [Enabled] bit  NOT NULL,
    [Name] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'GM_Metadata'
CREATE TABLE [dbo].[GM_Metadata] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ItemId] int  NOT NULL,
    [MetadataName] nvarchar(256)  NOT NULL,
    [MetadataType] nvarchar(128)  NOT NULL,
    [ValueDecimal] decimal(30,10)  NULL,
    [ValueDate] datetimeoffset  NULL,
    [ValueText] nvarchar(512)  NULL,
    [ValueTextFull] nvarchar(max)  NULL,
    [ValueChecked] bit  NULL,
    [ValueNumber] int  NULL,
    [ValueTaxonomyId] nvarchar(512)  NULL,
    [MetadataDefinition_Id] int  NOT NULL
);
GO

-- Creating table 'GM_MetadataDefinition'
CREATE TABLE [dbo].[GM_MetadataDefinition] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Schema] nvarchar(max)  NOT NULL,
    [MetadataName] nvarchar(256)  NOT NULL,
    [Deleted] bit  NOT NULL
);
GO

-- Creating table 'GM_EventHistory'
CREATE TABLE [dbo].[GM_EventHistory] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Created] datetimeoffset  NOT NULL,
    [CreatedBy] int  NOT NULL,
    [Comment] nvarchar(max)  NOT NULL,
    [ItemId] int  NOT NULL,
    [EventRegistrationId] int  NOT NULL,
    [EventData] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'GM_AdminChangeLog'
CREATE TABLE [dbo].[GM_AdminChangeLog] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Created] datetimeoffset  NOT NULL,
    [CreatedBy] int  NOT NULL,
    [Comment] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'GM_ItemHistory'
CREATE TABLE [dbo].[GM_ItemHistory] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Created] datetimeoffset  NOT NULL,
    [CreatedBy] int  NOT NULL,
    [Comment] nvarchar(max)  NOT NULL,
    [ItemId] int  NOT NULL
);
GO

-- Creating table 'GM_ItemTypeMetadataDefinitionBinding'
CREATE TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ItemTypeId] int  NOT NULL,
    [SortOrder] int  NOT NULL,
    [MetadataDefinition_Id] int  NOT NULL
);
GO

-- Creating table 'GM_Resource'
CREATE TABLE [dbo].[GM_Resource] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ItemId] int  NOT NULL,
    [Name] nvarchar(128)  NOT NULL,
    [Data] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'GM_WhitelistedRequest'
CREATE TABLE [dbo].[GM_WhitelistedRequest] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Url] nvarchar(max)  NOT NULL,
    [Method] nvarchar(max)  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'GM_Item'
ALTER TABLE [dbo].[GM_Item]
ADD CONSTRAINT [PK_GM_Item]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_ItemType'
ALTER TABLE [dbo].[GM_ItemType]
ADD CONSTRAINT [PK_GM_ItemType]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_EventRegistration'
ALTER TABLE [dbo].[GM_EventRegistration]
ADD CONSTRAINT [PK_GM_EventRegistration]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_Metadata'
ALTER TABLE [dbo].[GM_Metadata]
ADD CONSTRAINT [PK_GM_Metadata]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_MetadataDefinition'
ALTER TABLE [dbo].[GM_MetadataDefinition]
ADD CONSTRAINT [PK_GM_MetadataDefinition]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_EventHistory'
ALTER TABLE [dbo].[GM_EventHistory]
ADD CONSTRAINT [PK_GM_EventHistory]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_AdminChangeLog'
ALTER TABLE [dbo].[GM_AdminChangeLog]
ADD CONSTRAINT [PK_GM_AdminChangeLog]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_ItemHistory'
ALTER TABLE [dbo].[GM_ItemHistory]
ADD CONSTRAINT [PK_GM_ItemHistory]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_ItemTypeMetadataDefinitionBinding'
ALTER TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding]
ADD CONSTRAINT [PK_GM_ItemTypeMetadataDefinitionBinding]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_Resource'
ALTER TABLE [dbo].[GM_Resource]
ADD CONSTRAINT [PK_GM_Resource]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GM_WhitelistedRequest'
ALTER TABLE [dbo].[GM_WhitelistedRequest]
ADD CONSTRAINT [PK_GM_WhitelistedRequest]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [ItemTypeId] in table 'GM_Item'
ALTER TABLE [dbo].[GM_Item]
ADD CONSTRAINT [FK_GM_ItemTypeGM_Item]
    FOREIGN KEY ([ItemTypeId])
    REFERENCES [dbo].[GM_ItemType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemTypeGM_Item'
CREATE INDEX [IX_FK_GM_ItemTypeGM_Item]
ON [dbo].[GM_Item]
    ([ItemTypeId]);
GO

-- Creating foreign key on [ItemId] in table 'GM_Metadata'
ALTER TABLE [dbo].[GM_Metadata]
ADD CONSTRAINT [FK_GM_ItemGM_Metadata]
    FOREIGN KEY ([ItemId])
    REFERENCES [dbo].[GM_Item]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemGM_Metadata'
CREATE INDEX [IX_FK_GM_ItemGM_Metadata]
ON [dbo].[GM_Metadata]
    ([ItemId]);
GO

-- Creating foreign key on [MetadataDefinition_Id] in table 'GM_Metadata'
ALTER TABLE [dbo].[GM_Metadata]
ADD CONSTRAINT [FK_GM_MetadataGM_MetadataDefinition]
    FOREIGN KEY ([MetadataDefinition_Id])
    REFERENCES [dbo].[GM_MetadataDefinition]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_MetadataGM_MetadataDefinition'
CREATE INDEX [IX_FK_GM_MetadataGM_MetadataDefinition]
ON [dbo].[GM_Metadata]
    ([MetadataDefinition_Id]);
GO

-- Creating foreign key on [ItemTypeId] in table 'GM_EventRegistration'
ALTER TABLE [dbo].[GM_EventRegistration]
ADD CONSTRAINT [FK_GM_ItemTypeGM_Event]
    FOREIGN KEY ([ItemTypeId])
    REFERENCES [dbo].[GM_ItemType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemTypeGM_Event'
CREATE INDEX [IX_FK_GM_ItemTypeGM_Event]
ON [dbo].[GM_EventRegistration]
    ([ItemTypeId]);
GO

-- Creating foreign key on [ItemTypeId] in table 'GM_ItemTypeMetadataDefinitionBinding'
ALTER TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding]
ADD CONSTRAINT [FK_GM_ItemTypeGM_ItemTypeMetadataDefinitionBinding]
    FOREIGN KEY ([ItemTypeId])
    REFERENCES [dbo].[GM_ItemType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemTypeGM_ItemTypeMetadataDefinitionBinding'
CREATE INDEX [IX_FK_GM_ItemTypeGM_ItemTypeMetadataDefinitionBinding]
ON [dbo].[GM_ItemTypeMetadataDefinitionBinding]
    ([ItemTypeId]);
GO

-- Creating foreign key on [MetadataDefinition_Id] in table 'GM_ItemTypeMetadataDefinitionBinding'
ALTER TABLE [dbo].[GM_ItemTypeMetadataDefinitionBinding]
ADD CONSTRAINT [FK_GM_ItemTypeMetadataDefinitionBindingGM_MetadataDefinition]
    FOREIGN KEY ([MetadataDefinition_Id])
    REFERENCES [dbo].[GM_MetadataDefinition]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemTypeMetadataDefinitionBindingGM_MetadataDefinition'
CREATE INDEX [IX_FK_GM_ItemTypeMetadataDefinitionBindingGM_MetadataDefinition]
ON [dbo].[GM_ItemTypeMetadataDefinitionBinding]
    ([MetadataDefinition_Id]);
GO

-- Creating foreign key on [ItemId] in table 'GM_ItemHistory'
ALTER TABLE [dbo].[GM_ItemHistory]
ADD CONSTRAINT [FK_GM_ItemGM_ItemHistory]
    FOREIGN KEY ([ItemId])
    REFERENCES [dbo].[GM_Item]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemGM_ItemHistory'
CREATE INDEX [IX_FK_GM_ItemGM_ItemHistory]
ON [dbo].[GM_ItemHistory]
    ([ItemId]);
GO

-- Creating foreign key on [ItemId] in table 'GM_Resource'
ALTER TABLE [dbo].[GM_Resource]
ADD CONSTRAINT [FK_GM_ItemGM_Resource]
    FOREIGN KEY ([ItemId])
    REFERENCES [dbo].[GM_Item]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GM_ItemGM_Resource'
CREATE INDEX [IX_FK_GM_ItemGM_Resource]
ON [dbo].[GM_Resource]
    ([ItemId]);
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------